% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.AUC.test.R
\name{rss.AUC.test}
\alias{rss.AUC.test}
\title{RSS empirical likelihood ratio (ELR) test in two-sample comparison}
\usage{
rss.AUC.test(data1, data2, alpha = 0.05, delta0 = 0.5)
}
\arguments{
\item{data1}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{data2}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{delta0}{A numeric value indicating the hypothesized value of the AUC.}
}
\value{
\item{RSS_AUC}{The RSS AUC estimate.}
\item{CI}{The confidence interval for the AUC.}
\item{-2*Log.LR}{The empirical log likelihood ratio test statistics.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.AUC.test function conducts an empirical likelihood ratio test to compare the Area Under the Curve (AUC) between two groups using RSS. It supports both balanced and unbalanced RSS designs.
}
\details{
This function performs an empirical likelihood ratio test to compare the Area Under the Curve (AUC) between two groups using Ranked Set Sampling (RSS). The test is equivalent to the Mann-Whitney U test, which evaluates whether there is a significant difference between the distributions of two groups. The function supports both Balanced RSS (BRSS) and unbalanced RSS (URSS), as described by Moon et al. (2022). Given two data frames of RSS data (\code{data1} and \code{data2}) with \code{rank} and \code{y} columns, the function calculates the empirical likelihood ratio test statistic, confidence interval, and p-value based on the hypothesized AUC value \code{delta0}. Test for \code{delta0}=0.5 corresponds to the null hypothesis of the Mann-Whitney U test, which asserts that there is no difference between the two groups, implying that any randomly selected observation from one group is just as likely to be greater or smaller than an observation from the other group.
}
\examples{
## balanced RSS with a set size 3 and different sample sizes of 6 or 8 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data1<-rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)
rss.data2<-rss.simulation(H=3,nsamp=c(8,8,8),dist="normal", rho=0.8,delta=0.2)

## RSS empirical likelihood ratio test
rss.AUC.test(data1=rss.data1, data2=rss.data2, alpha=0.05, delta0=0.5)

## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data1<-rss.simulation(H=3,nsamp=c(6,10,8),dist="normal", rho=0.8,delta=0)
rss.data2<-rss.simulation(H=3,nsamp=c(6,10,8),dist="normal", rho=0.8,delta=0.2)

## RSS empirical likelihood ratio test
rss.AUC.test(data1=rss.data1, data2=rss.data2, alpha=0.05, delta0=0.5)

}
\references{
C. Moon, X. Wang, and J. Lim. (2022) Empirical likelihood inference for area under the receiver operating characteristic curve using ranked set samples. Pharmaceutical Statistics, 21(6), 1219–1245.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
