% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesys.R
\name{get_accessions}
\alias{get_accessions}
\title{Get accession passport data as a data table.}
\usage{
get_accessions(filters = NULL, fields = SELECT_INFO_FIELDS)
}
\arguments{
\item{filters}{an R \code{structure} with Genesys filters}

\item{fields}{list of fields to fetch from Genesys. See examples. The following constants are also available SELECT_INFO_FIELDS, SELECT_GEO_FIELDS and SELECT_INFO_FIELDS (default).}
}
\value{
Data table
}
\description{
Get accession passport data as a data table.
}
\examples{
\dontrun{
  # Retrieve all accession data by country of origin (Slovenia, Ivory Coast)
  accessions <- genesysr::get_accessions(list(countryOfOrigin = list(code3 = list("SVN", "CIV"))))

  # Focus on geolocation data
  musa <- genesysr::get_accessions(
    list(taxonomy = list(genus = list("Musa"))),
    select = genesysr::SELECT_GEO_FIELDS
  )

  # Fetch only accession number and coordinates of Musa accessions
  musa <- genesysr::get_accessions(
    list(taxonomy = list(genus = list("Musa"))),
    fields = c("ACCENUMB", "DECLATITUDE", "DECLONGITUDE")
  )
}

}
\seealso{
\code{\link{mcpd_filter}}
}
