% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chicagocomm.R
\docType{data}
\name{chicago_comm}
\alias{chicago_comm}
\title{Chicago Community Areas (2010).}
\format{An sf data frame with 77 rows, 4 variables, and a geometry column:
\describe{
  \item{community}{Community name}
  \item{area_num_1}{Community ID}
  \item{NID}{Community ID (repeated)}
  \item{POP2010}{Population in 2010}
  \item{geometry}{MULTIPOLYGON}
}}
\source{
\url{https://data.cityofchicago.org/Facilities-Geographic-Boundaries/Boundaries-Community-Areas-current-/cauq-8yn6}
}
\usage{
chicago_comm
}
\description{
Population in Chicago community areas in 2010.
}
\details{
Sf object, unprojected. EPSG 4326: WGS84.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(sf)
  data(chicago_comm)

  plot(chicago_comm["community"])
}
}
\keyword{datasets}
