% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localsurface.R
\name{findvalleys}
\alias{findvalleys}
\title{Find Local Valleys}
\usage{
findvalleys(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A dataframe of local valley locations (\code{x, y}) and
  values (\code{val}). The raster or matrix location index (\code{ind}),
  row (\code{row}), and column (\code{col}) are also listed.
}
\description{
Locates local valleys on a raster or matrix. A valley is defined as any pixel where
all 8 surrounding pixels have higher values, and the center pixel
has a negative value.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# locate peaks and valleys
peaks <- findpeaks(normforest)
valleys <- findvalleys(normforest)

# find top 5 peaks, valleys
top_peaks <- peaks[order(peaks$val, decreasing = TRUE)[1:5],]
bottom_valleys <- valleys[order(valleys$val)[1:5],]

# calculate the ten-point height
S10z <- (sum(top_peaks$val) + sum(abs(bottom_valleys$val))) / 5
}
