% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_anp_peru.R
\name{get_anp_peru}
\alias{get_anp_peru}
\title{Download Spatial Data of Protected Natural Areas (ANP) in Peru}
\usage{
get_anp_peru(anp = NULL, showProgress = TRUE)
}
\arguments{
\item{anp}{A character or a vector with the name(s) of the protected natural areas in Peru.}

\item{showProgress}{Logical TRUE or FALSE to display a progress bar during download.}
}
\value{
An \verb{"sf" "data.frame"} object containing the spatial data of Peru's protected natural areas.
}
\description{
Downloads spatial data of protected natural areas in Peru declared by SERNAP (National Service of Natural Protected Areas).
Data were obtained from \href{https://geo.sernanp.gob.pe/visorsernanp/}{GEO ANP} as the official source. The data are in the "WGRS84" reference system and CRS(4326).
}
\examples{
\donttest{
# Read specific ANP
manu <- get_anp_peru(anp = "Manu")

pampa_galeras <- get_anp_peru(anp = "Pampa Galeras")

# Read more than one ANP
anps <- get_anp_peru(anp = c("Manu", "Yanachaga", "Calipuy"))
}
}
