% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_Colors.R
\docType{data}
\name{ICS_Colors}
\alias{ICS_Colors}
\title{The CGMW ICS color codes}
\format{
A data frame with 194 rows and the following
11 columns:\cr
\describe{
\item{standard sorting order}{ICS' ordering of this entry}
\item{Long List (isc:)}{Entries name prefixed by \verb{ics:}}
\item{Long List (formatted)}{The (common) name of entry, e.g. 'Holocene'}
\item{Rank}{Is the entry a System, Series, Stage, ...}
\item{Cyan, Magenta, Yellow, Black}{Color's values in the CMYK color model}
\item{Red, Green, Blue}{Color's values in the RGB color model}
}
}
\usage{
ICS_Colors
}
\description{
A data set containing the color codes used by the
\href{https://stratigraphy.org/chart}{International Chronostratigraphic Chart} by the
\href{https://stratigraphy.org/}{International Commission on Stratigraphy} (ICS)
\insertCite{Cohen2013}{georefdatar}.
}
\details{
The coloring in this chart follows the
\href{https://ccgm.org/}{Commission for the Geological Map of the World} (CGMW)
\insertCite{Vrielynck2022}{georefdatar}.
}
\references{
{
\insertRef{Cohen2013}{georefdatar}

\insertRef{Vrielynck2022}{georefdatar}
}
}
\seealso{
\code{\link[=icsColor]{icsColor()}} a convenience function to get a specific color.
}
\keyword{datasets}
