% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atomicWeight.R
\name{aw}
\alias{aw}
\title{Get the atomic weight of an element}
\usage{
aw(sym, dataSource = "IUPAC")
}
\arguments{
\item{sym}{symbol of the element as a string}

\item{dataSource}{the data source for the atomic weight, either \code{IUPAC}
(default) or \code{PubChem}. This is case insensitive ("IUPAC" is the same as
e.g. "IuPaC")}
}
\value{
Atomic weight of element with the given symbol
}
\description{
Get the atomic weight of an element
}
\examples{
aw('H')
aw('H')*2+aw('O')

aw('Li', dataSource= "pubchem")

}
\seealso{
\link{IUPAC_StdAW} for the table of standard atomic weights
by IUPAC and \link{pte} for a full periodic table of elements
}
