% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12-workflows.R
\name{run_comprehensive_geospatial_workflow}
\alias{run_comprehensive_geospatial_workflow}
\title{Run comprehensive geospatial workflow -}
\usage{
run_comprehensive_geospatial_workflow(analysis_config)
}
\arguments{
\item{analysis_config}{List containing analysis configuration with required fields:
\itemize{
\item analysis_type: "ndvi_crop_analysis", "water_quality_analysis",
"terrain_analysis", "temporal_analysis", "vegetation_comprehensive",
"mosaic_analysis", "interactive_mapping"
\item input_data: Input data paths or objects
\item region_boundary: Region boundary specification
\item output_folder: Output directory (optional)
\item visualization_config: Visualization settings (optional)
}}
}
\value{
List containing analysis results, visualizations, summary, and configuration
}
\description{
Execute complete geospatial analysis workflows with simplified visualization.
to handle test cases and provide robust error handling without complex dependencies.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Simple NDVI crop analysis workflow
config <- list(
  analysis_type = "ndvi_crop_analysis",
  input_data = list(red = red_raster, nir = nir_raster),
  region_boundary = "Ohio",
  output_folder = "results/"
)
results <- run_comprehensive_geospatial_workflow(config)
}

}
