% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gerda_census.R
\name{gerda_census}
\alias{gerda_census}
\title{Get Municipality-Level Census 2022 Data}
\usage{
gerda_census()
}
\value{
A data frame with approximately 10,800 rows (one per municipality)
and 16 columns containing census indicators. See
\code{\link{gerda_census_codebook}} for variable descriptions.
}
\description{
Returns municipality-level demographic and socioeconomic data from the
German Census 2022 (Zensus 2022). This is a cross-sectional snapshot
covering all German municipalities.

For most users, we recommend using \code{\link{add_gerda_census}} instead,
which automatically merges census data with GERDA election data.
}
\details{
The dataset includes:
\itemize{
\item Demographics: Population, age structure
\item Migration: Migration background, foreign nationals
\item Households: Average household size
\item Housing: Dwellings, vacancy, ownership, rents, building types
}

Municipality codes are 8-digit AGS codes. Since the census is a single
2022 snapshot, there is no year dimension.
}
\examples{
# Get the census data
census <- gerda_census()
head(census)

# Check available municipalities
nrow(census)

}
\seealso{
\itemize{
\item \code{\link{add_gerda_census}} for automatic merging with election data
\item \code{\link{gerda_census_codebook}} for variable descriptions
}
}
