% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gesis_download.R
\name{gesis_download}
\alias{gesis_download}
\title{Download datasets from the GESIS data archive}
\usage{
gesis_download(
  file_id,
  email = getOption("gesis_email"),
  password = getOption("gesis_password"),
  use = getOption("gesis_use"),
  reset = FALSE,
  download_dir = "gesis_data",
  msg = TRUE,
  convert = TRUE,
  delay = 5
)
}
\arguments{
\item{file_id}{The unique identifier (or optionally a vector of these identifiers).
for the dataset(s) to be downloaded (see details).}

\item{email, password}{Your GESIS email and password (see details).}

\item{use}{The number of a 'use of data' (see details).}

\item{reset}{If TRUE, you will be asked to re-enter your username, password, and use.}

\item{download_dir}{The directory (relative to your working directory) to
which files from the GESIS data archive will be downloaded.}

\item{msg}{If TRUE, outputs a message showing which data set is being downloaded.}

\item{convert}{If TRUE, converts downloaded file(s) to .RData format.}

\item{delay}{If the speed of your connection to the GESIS data archive is particularly slow, 
\code{gesis_download} may encounter problems.  Increasing the \code{delay} parameter
may help.}
}
\value{
The function returns downloaded files.
}
\description{
\code{gesis_download} provides a programmatic and reproducible means to download datasets 
  from the GESIS data archive
}
\details{
To avoid requiring others to edit your scripts to insert their own email, 
 password, and use or to force them to do so interactively, the default is set to fetch 
 this information from the user's .Rprofile.  Before running \code{gesis_download}, 
 then, you should be sure to add these options to your .Rprofile substituting your 
 info for the example below:

 \code{
  options("gesis_email" = "juanita-herrara@uppermidwest.edu",
          "gesis_password" = "password123!",
          "gesis_use" = 5)
 }
  In addition to accepting the terms of use, you need to input a purpose for
  downloading a data set. The options are as follows:

1. for final thesis of the study programme (e.g. Bachelor/Master thesis)
2. for reserach with a commercial mission
3. for non-scientific purposes
4. for further education and qualification
5. for scientific research (incl. doctorate)
6. in the course of my studies
7. in a course as lecturer
}
\examples{
\dontrun{
 gesis_download(file_id = c("ZA6644", "ZA6900"),
                download_dir = tempdir()) # remember to specify a directory for your download
}

}
