% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getip.r
\name{getip}
\alias{getip}
\title{ip_external}
\usage{
getip(type = "local")
}
\arguments{
\item{type}{One of \code{"local"} or \code{"internal"} for the local/internal IP, or
one of \code{"external"} or \code{"public"} for the external/public IP.}
}
\value{
Returns the requested IP address as a string.
}
\description{
Get your internal/local or external/public IP address. Currently only IPv4
addresses are supported.
}
\details{
The internal/local IP lookup is done in-process, i.e., it does not call
\code{system()} or the like.

For an external address, the function returns a lookup from one of several
services, including
Amazon AWS \url{http://checkip.amazonaws.com/}, 
httpbin \url{http://httpbin.org/ip},
ipify \url{https://www.ipify.org/},
and "My External IP address is ..." \url{http://myexternalip.com/}.
You must be connected to the internet for this to work. Please note that
pathological use could end up in your getting banned from these services, 
rendering the function useless. So don't call this function a billion times
in a loop or something.
}
\examples{
library(getip)

# internal/local address
getip("local") # same as getip("internal")

\donttest{
# external/public
getip("public") # same as getip("external")
}

}
