% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.R
\name{coord_brick}
\alias{coord_brick}
\alias{coord_waffle}
\title{Cartesian coordinates with fixed "aspect ratio"}
\usage{
coord_brick(
  bricks_per_layer = 4,
  ratio = NULL,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  clip = "on",
  width = 0.9
)

coord_waffle(
  bricks_per_layer = 4,
  ratio = NULL,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  clip = "on",
  width = 0.9
)
}
\arguments{
\item{bricks_per_layer}{Number of bricks per layer. Should match the \code{bricks_per_layer}
specification in \code{geom_brick}. Default is \code{4}.}

\item{ratio}{aspect ratio, expressed as \code{y / x}}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins.}

\item{width}{Column width. If using a different \code{width} in \code{geom_brick}
use the same \code{width} here to ensure correct scaling.}
}
\value{
ggplot object
}
\description{
A fixed scale coordinate system forces a specified ratio similar to
\code{coord_fixed}. It holds the coordinates fixed at the right ratio
to ensure each brick is of the right dimensions.
}
\examples{
# ensures that the ranges of axes are equal to the specified ratio by

library(ggplot2)
library(dplyr)

# create a base plot
plt <- mpg \%>\%
  count(class, drv) \%>\%
  ggplot() +
  geom_brick(aes(class, n, fill = drv), bricks_per_layer = 6)

# view the base plot
plt

# View the base plot with fixed coords
# Ensure `bricks_per_layer` matches the geom
plt \%>\%
  coord_brick(6)

# The same using `geom_waffle`
mpg \%>\%
  count(class, drv) \%>\%
  ggplot() +
  geom_waffle(aes(class, n, fill = drv), bricks_per_layer = 6) +
  coord_waffle(6)
}
