% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-pop-etho.R
\name{stat_pop_etho}
\alias{stat_pop_etho}
\title{Compute and display a population aggregate for a variable of interest}
\usage{
stat_pop_etho(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  ...,
  method = mean_se,
  method.args = list(),
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{function used to compute the aggregate and  confidence intervals.
It should return (\code{y}, \code{ymin} and \code{ymax}).
The default is \link[ggplot2:mean_se]{ggplot2::mean_se}, which computes the mean + or - standard error.
\link[ggplot2:hmisc]{ggplot2::mean_cl_boot} can be used instead to generate bootstrap confidence interval instead.}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggplot layer.
}
\description{
This function displays the temporal (time on the x axis) trend of variable of interest,
on the y axis as a line with confidence interval as a shaded area.
}
\examples{
library(behavr)
metadata <- data.frame(id = sprintf("toy_experiment | \%02d", 1:4),
                   age=c(1, 5, 10, 20),
                   condition=c("A", "B"))
dt <- toy_activity_data(metadata, 3)
# We build a plot object
pl <-  ggetho(dt, aes(y = asleep))
# A standard plot of the whole population:
pl + stat_pop_etho()
# We can also split by condition, and display the two population on different facets:
pl + stat_pop_etho() + facet_grid(condition ~ .)
\dontrun{
# Instead, we can use different colour for separate conditions:
pl <-  ggetho(dt, aes(y = asleep, colour = condition))
pl + stat_pop_etho()

# Sometimes, we also have numeric condition (e.g. age)
pl <-  ggetho(dt, aes(y = asleep, colour = age))
pl + stat_pop_etho()
# We could want to aggregate several days of data to one circadian day (i.e. time wrapping)
# here, we also plot the invert of moving (!moving)
pl <-  ggetho(dt, aes(y = !moving), time_wrap = hours(24))
pl + stat_pop_etho()
}
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/ggetho.html#population-plots}{rethomic tutorial section}
}
}
\seealso{
\itemize{
\item \link{ggetho} to generate a plot object
\item \link{stat_tile_etho} to show variable of interest as colour intensity
\item \link{stat_ld_annotations} to show light and dark phases on the plot
\item \link[ggplot2:geom_smooth]{ggplot2::stat_smooth} to understand how to change the type of confidence interval, line colour and so forth
}

Other layers: 
\code{\link{geom_peak}()},
\code{\link{stat_bar_tile_etho}()},
\code{\link{stat_ld_annotations}()}
}
\concept{layers}
