% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_position.R
\name{legend_left}
\alias{legend_left}
\title{Place Legend on the Left with Proper Alignment}
\usage{
legend_left(by = NULL)
}
\arguments{
\item{by}{Optional aesthetic name (character) to position only a specific
legend. When specified, uses per-guide positioning via
\code{guide_legend(position = "left")}. Requires ggplot2 >= 3.5.0.
Common values: \code{"colour"}, \code{"fill"}, \code{"size"}.}
}
\value{
A ggplot2 theme object (when \code{by} is NULL) or a guides
specification (when \code{by} is specified).
}
\description{
A one-liner to position the legend on the left side of the plot with correct
left alignment for both the key box and text labels. This goes beyond simple
\code{legend.position = "left"} by also setting justification and box alignment.
}
\details{
When \code{by} is NULL (default), this function sets three theme elements:
\itemize{
\item \code{legend.position = "left"} to place the legend on the left
\item \code{legend.justification = "left"} to left-justify the legend box
\item \code{legend.box.just = "left"} to left-align multiple legend boxes
}

When \code{by} is specified, only the legend for that aesthetic is moved,
allowing different legends to be placed in different positions.
}
\examples{
library(ggplot2)

# Basic usage
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_left()

# Works with multiple legends
ggplot(mtcars, aes(mpg, wt, color = factor(cyl), shape = factor(am))) +
  geom_point(size = 3) +
  legend_left()

# Position only the colour legend on the left
ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp)) +
  geom_point() +
  legend_left(by = "colour") +
  legend_bottom(by = "size")

}
\seealso{
\code{\link{legend_right}}, \code{\link{legend_top}},
\code{\link{legend_bottom}}, \code{\link{legend_inside}},
\code{\link{legend_none}}
}
