% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_multi.R
\name{legend_merge}
\alias{legend_merge}
\title{Force Legends to Merge}
\usage{
legend_merge(...)
}
\arguments{
\item{...}{Aesthetic names (unquoted) to merge. E.g., \code{colour, fill}.}
}
\value{
A guides specification that can be added to a plot.
}
\description{
Force specified legends to merge together by setting them to the same order.
Legends will only merge if they have matching labels (same factor levels or
break values).
}
\details{
ggplot2 automatically merges legends when they have the same title and
matching labels. This function ensures legends have the same order value
(order = 0), which is a prerequisite for merging.

If legends still don't merge after using this function, ensure:
\itemize{
\item Both aesthetics map to the same variable
\item The legends have identical titles (use \code{labs()})
\item The breaks/labels are identical
}
}
\examples{
library(ggplot2)

# Plot where colour and fill map to the same variable
p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl), fill = factor(cyl))) +
  geom_point(shape = 21, size = 3, stroke = 1.5) +
  labs(color = "Cylinders", fill = "Cylinders")

# Force merge (they should merge automatically if labels match)
p + legend_merge(colour, fill)

}
\seealso{
\code{\link{legend_split}}, \code{\link{legend_order_guides}}
}
