% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_position.R
\name{legend_vertical}
\alias{legend_vertical}
\title{Set Legend Direction to Vertical}
\usage{
legend_vertical()
}
\value{
A ggplot2 theme object that can be added to a plot.
}
\description{
A one-liner to arrange legend keys vertically. This is the default for
legends placed on the left or right of a plot.
}
\examples{
library(ggplot2)

# Explicitly set vertical direction
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_right() +
  legend_vertical()

}
\seealso{
\code{\link{legend_horizontal}}, \code{\link{legend_left}},
\code{\link{legend_right}}
}
