% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{print.gglasso}
\alias{print.gglasso}
\title{print a gglasso object}
\usage{
\method{print}{gglasso}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted \code{\link{gglasso}} object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\value{
a two-column matrix, the first columns is the number of nonzero
group counts and the second column is \code{Lambda}.
}
\description{
Print the nonzero group counts at each lambda along the gglasso path.
}
\details{
Print the information about the nonzero group counts at each lambda step in
the \code{\link{gglasso}} object. The result is a two-column matrix with
columns \code{Df} and \code{Lambda}. The \code{Df} column is the number of
the groups that have nonzero within-group coefficients, the \code{Lambda}
column is the the corresponding lambda.
}
\examples{

# load gglasso library
library(gglasso)

# load data set
data(colon)

# define group index
group <- rep(1:20,each=5)

# fit group lasso
m1 <- gglasso(x=colon$x,y=colon$y,group=group,loss="logit")

# print out results
print(m1)
}
\references{
Yang, Y. and Zou, H. (2015), ``A Fast Unified Algorithm for
Computing Group-Lasso Penalized Learning Problems,'' \emph{Statistics and
Computing}. 25(6), 1129-1141.\cr BugReport:
\url{https://github.com/archer-yang-lab/gglasso}\cr
}
\author{
Yi Yang and Hui Zou\cr Maintainer: Yi Yang <yi.yang6@mcgill.ca>
}
\keyword{models}
\keyword{regression}
