% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pred.R
\name{plot_pred}
\alias{plot_pred}
\title{Plot the predictor matrix of an imputation model}
\usage{
plot_pred(
  data,
  vrb = "all",
  method = NULL,
  label = TRUE,
  square = TRUE,
  rotate = FALSE
)
}
\arguments{
\item{data}{A predictor matrix for \code{mice}, typically generated with \link[mice:make.predictorMatrix]{mice::make.predictorMatrix} or \link[mice:quickpred]{mice::quickpred}, or an object of class \code{\link[mice:mids]{mice::mids}}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{method}{Character string or vector with imputation methods.}

\item{label}{Logical indicating whether predictor matrix values should be displayed.}

\item{square}{Logical indicating whether the plot tiles should be squares.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}
}
\value{
An object of class \code{ggplot2::ggplot}.
}
\description{
Plot the predictor matrix of an imputation model
}
\details{
The predictor matrix in \link[mice:mice]{mice::mice} determines the role an imputation model predictor takes in the imputation model.
The rows correspond to incomplete target variables, and the columns to imputation model predictors.

A value of \code{1} indicates that the column variable is a predictor to impute the target (row) variable. The value \code{0} means that it is not used as predictor.

Imputation methods for multilevel data use other codes than \code{0} and \code{1}:
\itemize{
\item Methods \verb{2l.bin}, \verb{2l.lmer}, \verb{2l.norm}, \verb{2l.pan}, \verb{2lonly.mean}, \verb{2lonly.norm} and \verb{2lonly.pmm} use code \code{-2} to indicate the class variable;
\item Methods \verb{2l.bin}, \verb{2l.lmer}, \verb{2l.norm} and \verb{2l.pan} use code \code{2} to indicate the random effects;
\item Method \verb{2l.pan} uses codes \code{3} and \code{4} to add class means to codes \code{1} and \code{2} respectively.
}
}
\examples{
# generate a predictor matrix
pred <- mice::quickpred(mice::nhanes)

# plot predictor matrix for all columns
plot_pred(pred)

# plot predictor matrix for specific columns by supplying a character vector
plot_pred(pred, c("chl", "hyp"))

# plot predictor matrix for specific columns by supplying unquoted variable names
plot_pred(pred, c(chl, hyp))

# plot predictor matrix for specific columns by passing an object with variable names
# from the environment, unquoted with `!!`
my_variables <- c("chl", "hyp")
plot_pred(pred, !!my_variables)
# object with variable names must be unquoted with `!!`
try(plot_pred(pred, my_variables))

# plot predictor matrix of mids object
imp <- mice::mice(mice::nhanes, print = FALSE)
plot_pred(imp)

}
\references{
van Buuren, S. (2018). Flexible imputation of missing data. Chapman and Hall/CRC. \href{https://stefvanbuuren.name/fimd/}{stefvanbuuren.name/fimd}
}
