% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_graph_node}
\alias{ggml_graph_node}
\title{Get Graph Node}
\usage{
ggml_graph_node(graph, i)
}
\arguments{
\item{graph}{Graph object}

\item{i}{Node index (0-based, negative indices count from end)}
}
\value{
Tensor pointer
}
\description{
Gets a specific node (tensor) from the computation graph by index
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_add(ctx, a, a)
graph <- ggml_build_forward_expand(ctx, b)
# Get the last node (output)
output <- ggml_graph_node(graph, -1)
ggml_free(ctx)
}
}
