% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-brewer.R, R/zxx.r
\name{scale_pattern_colour_brewer}
\alias{scale_pattern_colour_brewer}
\alias{scale_pattern_fill_brewer}
\alias{scale_pattern_fill2_brewer}
\alias{scale_pattern_colour_distiller}
\alias{scale_pattern_fill_distiller}
\alias{scale_pattern_fill2_distiller}
\alias{scale_pattern_color_brewer}
\alias{scale_pattern_color_distiller}
\title{Sequential, diverging and qualitative colour scales from colorbrewer.org}
\usage{
scale_pattern_colour_brewer(
  ...,
  type = "seq",
  palette = 1,
  direction = 1,
  aesthetics = "pattern_colour"
)

scale_pattern_fill_brewer(
  ...,
  type = "seq",
  palette = 1,
  direction = 1,
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_brewer(
  ...,
  type = "seq",
  palette = 1,
  direction = 1,
  aesthetics = "pattern_fill2"
)

scale_pattern_colour_distiller(
  ...,
  type = "seq",
  palette = 1,
  direction = -1,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_colour"),
  aesthetics = "pattern_colour"
)

scale_pattern_fill_distiller(
  ...,
  type = "seq",
  palette = 1,
  direction = -1,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_fill"),
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_distiller(
  ...,
  type = "seq",
  palette = 1,
  direction = -1,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_fill2"),
  aesthetics = "pattern_fill2"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}, \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}},
or \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}, for \code{brewer}, \code{distiller}, and \code{fermenter} variants
respectively, to control name, limits, breaks, labels and so forth.}

\item{palette}{If a string, will use that named palette. If a number, will index into
the list of palettes of appropriate \code{type}. The list of available palettes can found
in the Palettes section.}

\item{direction, type, aesthetics, values, space, na.value, guide}{See \code{ggplot2::scale_colour_brewer} for more information.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
The \code{brewer} scales provides sequential, diverging and qualitative
colour schemes from ColorBrewer. These are particularly well suited to
display discrete values on a map. See \url{https://colorbrewer2.org} for
more information.
}
\details{
The \code{brewer} scales were carefully designed and tested on discrete data.
They were not designed to be extended to continuous data, but results often
look good. Your mileage may vary.
}
\note{
The \code{distiller} scales extend brewer to continuous scales by smoothly
interpolating 7 colours from any palette to a continuous scale. The \code{fermenter}
scales provide binned versions of the brewer scales.
}
\section{Palettes}{

The following palettes are available for use with these scales:
\describe{
\item{Diverging}{BrBG, PiYG, PRGn, PuOr, RdBu, RdGy, RdYlBu, RdYlGn, Spectral}
\item{Qualitative}{Accent, Dark2, Paired, Pastel1, Pastel2, Set1, Set2, Set3}
\item{Sequential}{Blues, BuGn, BuPu, GnBu, Greens, Greys, Oranges,
OrRd, PuBu, PuBuGn, PuRd, Purples, RdPu, Reds, YlGn, YlGnBu, YlOrBr, YlOrRd}
}
Modify the palette through the \code{palette} arguement.
}

\examples{
  if (require("ggplot2")) {
    df <- data.frame(level = c("a", "b", "c", "d"),
                     outcome = c(2.3, 1.9, 3.2, 1))
    # discrete 'brewer' palette
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_brewer()
    plot(gg)

    # continuous 'distiller' palette
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = outcome),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_distiller()
    plot(gg)
  }
}
