% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg_atlas_data.R
\name{ggseg_data_tract}
\alias{ggseg_data_tract}
\alias{brain_data_tract}
\title{Create tract atlas data}
\usage{
ggseg_data_tract(sf = NULL, centerlines = NULL, meshes = NULL, ...)

brain_data_tract(sf = NULL, centerlines = NULL, meshes = NULL, ...)
}
\arguments{
\item{sf}{sf data.frame with columns label, view, geometry for 2D rendering.
Optional.}

\item{centerlines}{data.frame with columns:
\itemize{
\item label: tract identifier (character)
\item points: list-column of n x 3 matrices (centerline coordinates)
\item tangents: list-column of n x 3 matrices (for orientation coloring)
}}

\item{meshes}{Deprecated. Use centerlines instead. If provided, will be
converted to centerlines format.}

\item{...}{Absorbs legacy fields (e.g. tube_radius, tube_segments) from
old cached atlas objects.}
}
\value{
An object of class c("ggseg_data_tract", "ggseg_atlas_data")
}
\description{
Creates a data object for white matter tract atlases. Stores centerlines
compactly; tube meshes are generated at render time for efficiency.
}
\examples{
centerlines_df <- data.frame(
  label = "cst_left",
  points = I(list(matrix(rnorm(150), ncol = 3))),
  tangents = I(list(matrix(rnorm(150), ncol = 3)))
)
data <- ggseg_data_tract(centerlines = centerlines_df)
}
