% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_ul.R
\name{theme_ul}
\alias{theme_ul}
\title{Theme UL}
\usage{
theme_ul(
  legend.position = "top",
  panel.background.fill = "#E8E9EA",
  plot.background.fill = "white",
  panel.grid.major.color = NULL,
  legend.justification = c(0, 1),
  legend.key = element_rect(fill = "transparent"),
  text = element_text(colour = "#58595b"),
  axis.text = element_text(colour = "#58595b"),
  strip.text.x = element_text(colour = "#58595b"),
  plot.caption = element_text(hjust = 1),
  legend.title = element_text(face = "bold"),
  axis.title = element_text(face = "bold"),
  plot.title = element_text(face = "bold"),
  plot.subtitle = element_text(hjust = 0),
  legend.background = element_rect(fill = "transparent", colour = "transparent"),
  ...
)
}
\arguments{
\item{legend.position}{A character string that specifies the position of the legend. Default is \code{"top"}.}

\item{panel.background.fill}{A character string that specifies the HEX code for the color of the panel background. Default is \code{"#E8E9EA"}.}

\item{plot.background.fill}{A character string that specifies the HEX code for the color of the plot background. Default is \code{"white"}.}

\item{panel.grid.major.color}{A character string that specifies the HEX code for the color of the major grid lines. If left as \code{NULL} (the default setting), the color will be automatically set according to the \code{panel.background.fill} parameter.}

\item{legend.justification}{A numeric vector of length 2 that determines the justification of the legend. Default is \code{c(0, 1)}.}

\item{legend.key}{An \code{element_rect} object defining the appearance of the legend key. Default is \code{element_rect(fill = "transparent")}.}

\item{text}{A ggplot2 element specifying the appearance of text elements in the plot.}

\item{axis.text}{A ggplot2 element specifying the appearance of axis text in the plot.}

\item{strip.text.x}{A ggplot2 element specifying the appearance of strip text for x-axis facet labels.}

\item{plot.caption}{A ggplot2 element specifying the appearance of the plot caption.}

\item{legend.title}{A ggplot2 element specifying the appearance of the legend title.}

\item{axis.title}{A ggplot2 element specifying the appearance of axis titles.}

\item{plot.title}{A ggplot2 element specifying the appearance of the plot title.}

\item{plot.subtitle}{A ggplot2 element specifying the appearance of the plot subtitle.}

\item{legend.background}{A ggplot2 element specifying the appearance of the legend background.}

\item{...}{Other arguments passed on to the function `theme()`.}
}
\value{
A ggplot2 theme object that can be added to a ggplot.
}
\description{
This function creates a ggplot2 theme that follows the visual identity of the University of Ljubljana.
}
\examples{
ggplot(data = mtcars, aes(x = disp, y = mpg, color = qsec, size = wt)) +
geom_point() +
labs(y = "Miles per gallon",
x = "Engine size (cu. in.) ",
title = "Larger engine consume more gas",
subtitle = "V-shape engines are typically larger",
caption = "Data source: Motor Trend US magazine.",
color = "1/4 mile time (seconds)",
size = "Weight (1000 lbs)") +
scale_color_ul(palette = "red", discrete = FALSE) +
theme_ul(plot.background.fill = ul_color("lajt"))
}
\seealso{
\code{\link[ggplot2]{theme}}
}
