% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggvolc.R
\name{ggvolc}
\alias{ggvolc}
\title{Create a Volcano Plot}
\usage{
ggvolc(
  data1,
  data2 = NULL,
  size_var = NULL,
  p_value = 0.05,
  fc = 1,
  not_sig_color = "#808080",
  down_reg_color = "#00798c",
  up_reg_color = "#d1495b",
  add_seg = FALSE
)
}
\arguments{
\item{data1}{Data frame for the primary dataset.}

\item{data2}{Data frame for the secondary dataset. Default is NULL.}

\item{size_var}{Variable for determining the size of points. Options are "log2FoldChange" and "pvalue". Default is "log2FoldChange".}

\item{p_value}{Threshold for statistical significance. Default is 0.05.}

\item{fc}{Fold change threshold for determining upregulated or downregulated genes. Default is 1.}

\item{not_sig_color}{Color for non-significant genes. Default is "grey82".}

\item{down_reg_color}{Color for downregulated genes. Default is "#00798c".}

\item{up_reg_color}{Color for upregulated genes. Default is "#d1495b".}

\item{add_seg}{Logical. If TRUE, dashed lines will be added to the plot indicating the p-value and fold change thresholds. Default is FALSE.}
}
\value{
A ggplot2 object displaying the volcano plot.
}
\description{
This function creates a volcano plot using ggplot2 based on provided datasets.
It is particularly useful for visualizing differential gene expression data.
}
\examples{
# Load example datasets included in the package
data(all_genes)
data(attention_genes)

# Create a basic volcano plot with default settings
# Points are colored by significance (p < 0.05, |log2FC| > 1)
ggvolc(all_genes)

# Highlight specific genes of interest with labels
# These genes are shown with black borders and gene names
ggvolc(all_genes, attention_genes)

# Add dashed lines to indicate significance thresholds
ggvolc(all_genes, attention_genes, add_seg = TRUE)

# Customize colors for up- and down-regulated genes
ggvolc(all_genes, attention_genes,
       up_reg_color = "#E63946",
       down_reg_color = "#457B9D")

# Scale point size by p-value instead of default
ggvolc(all_genes, attention_genes, size_var = "pvalue")

# Adjust significance thresholds (p-value and fold change)
ggvolc(all_genes, p_value = 0.01, fc = 2)

}
