% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghyp-attribution.R
\name{ESghyp.attribution}
\alias{ESghyp.attribution}
\title{Risk attribution.}
\usage{
ESghyp.attribution(
  alpha,
  object = ghyp(),
  distr = c("return", "loss"),
  weights = NULL,
  ...
)
}
\arguments{
\item{alpha}{a vector of confidence levels for ES.}

\item{object}{a multivariate fitted ghyp object inheriting from class \code{\link[=ghyp-class]{ghyp}}.}

\item{distr}{whether the ghyp-object specifies a return or a loss-distribution (see \bold{Details}).}

\item{weights}{vector of portfolio weights. Default is an equally-weighted portfolio.}

\item{...}{optional arguments passed from \linkS4class{ghyp.attribution} to \code{\link{qghyp}} and \code{\link{integrate}}.}
}
\value{
\code{ESghyp.attribution} is an object of class \linkS4class{ghyp.attribution}.
}
\description{
Functions to get the \emph{contribution} of each asset to the portfolio's 
\emph{Expected Shortfall} based on multivariate generalized hyperbolic 
distributions as well as the expected shortfall \emph{sensitivity} to marginal
changes in portfolio allocation.
}
\details{
The parameter \code{distr} specifies whether the ghyp-object 
describes a return or a loss-distribution.  In case of a return
distribution the expected-shortfall on a confidence level
\eqn{\alpha}{alpha} is defined as \eqn{\hbox{ES}_\alpha := 
\hbox{E}(X| X \leq F^{-1}_X(\alpha))}{ES_alpha := E(X | X <= F^-1(alpha))}
while in case of a loss distribution it is defined on a confidence
level \eqn{\alpha}{alpha} as \eqn{\hbox{ES}_\alpha := \hbox{E}(X | X
> F^{-1}_X(\alpha))}{ES_alpha := E(X | X > F^-1(alpha))}.\cr
}
\examples{
\dontrun{
data(smi.stocks)
## Fit a NIG model to Novartis, CS and Nestle log-returns
assets.fit <- fit.NIGmv(smi.stocks[, c("Novartis", "CS", "Nestle")], silent = TRUE)
## Define Weights of the Portfolio
weights <- c(0.2, 0.5, 0.3)
## Confidence level for Expected Shortfall
es.levels <- c(0.01)

portfolio.attrib <- ESghyp.attribution(alpha=es.levels, object=assets.fit, weights=weights)
}
}
\seealso{
\code{\link{contribution,ghyp.attribution-method}}, \code{\link{sensitivity,ghyp.attribution-method}} and \code{\link[=weights]{weights}} for Expected Shortfall.
}
\author{
Marc Weibel
}
\keyword{attribution}
\keyword{risk}
