% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_commits.R
\name{get_commits_pattern}
\alias{get_commits_pattern}
\title{Get commits associated with a text pattern}
\usage{
get_commits_pattern(
  repo = ".",
  pattern = c(Ticket = "#[[:digit:]]+"),
  pattern.table = NULL,
  ref = "main",
  path = NULL,
  silent = FALSE
)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{pattern}{Named vector with regex pattern to expose commits, like \verb{c("Issues" = "#\[\[:digit:\]\]")} for issues}

\item{pattern.table}{data.frame with two columns: pattern and description of the pattern.
This is used as correspondence table to add some names to existing patterns.}

\item{ref}{The name of a reference to list commits from e.g. a tag
or a branch. The default is NULL for the current branch.}

\item{path}{The path to a file. If not NULL, only commits modifying
this file will be returned. Note that modifying commits that
occurred before the file was given its present name are not
returned; that is, the output of \code{git log} with
\code{--no-follow} is reproduced.}

\item{silent}{Logical. Whether to hide messages.}
}
\value{
A tibble with one line for each commit, duplicated if
associated with multiple patterns and the following columns:
\itemize{
\item sha: sha of the commit
\item summary: First line of the commit message
\item message: Full content of the commit message
\item author: author of the commit
\item email: email of the author
\item when: commit time
\item order: order of commit messages. 1 is the oldest.
\item tag.name: name of tag associated with all commits since the last tag
\item tag.message: message of the tagged commit
\item pattern.type: name of the pattern found in the commit message
\item pattern.content: pattern found in the commit message
}
}
\description{
Get commits associated with a text pattern
}
\examples{
repo <- fake_repo()
get_commits_pattern(repo = repo, pattern = c("Ticket" = "#[[:digit:]]+"))
get_commits_pattern(repo = repo,
  pattern = c("Ticket" = "ticket[[:digit:]]+", "Issues" = "#[[:digit:]]+"))
}
