% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_list_group_members}
\alias{gl_list_group_members}
\title{List members of a specific group}
\usage{
gl_list_group_members(group, ...)
}
\arguments{
\item{group}{The ID or URL-encoded path of the group}

\item{...}{passed on to \code{\link[=gitlab]{gitlab()}} API call for "groups"}
}
\value{
A tibble with the group members information
}
\description{
List members of a specific group
}
\examples{
\dontrun{
set_gitlab_connection(
  gitlab_url = "https://gitlab.com",
  private_token = Sys.getenv("GITLAB_COM_TOKEN")
)
gl_list_group_members(group = "<<your-group-id>>")
}
}
