% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationMain.R
\name{givitiCalibrationTestComp}
\alias{givitiCalibrationTestComp}
\title{Computation of the Calibration Test}
\usage{
givitiCalibrationTestComp(o, e, devel, thres, maxDeg)
}
\arguments{
\item{o}{A numeric vector representing the binary outcomes.
The elements must assume only the values 0 or 1. The predictions
in \code{e} must represent the probability of the event
coded as 1.}

\item{e}{A numeric vector containing the probabilities of the
model under evaluation. The elements must be numeric and between 0 and 1.
The lenght of the vector must be equal to the length of the vector \code{o}.}

\item{devel}{A character string specifying if the model has been fit on
the same dataset under evaluation (\code{internal}) or if the model has
been developed on an external sample (\code{external}). See also the 'Details' sections.}

\item{thres}{A numeric scalar between 0 and 1 representing 1 - the significance level
adopted in the forward selection.}

\item{maxDeg}{The maximum degree considered in the forward selection.}
}
\value{
A list containing the following components:
\describe{
  \item{data}{A \code{data.frame} object with the numeric variables "o", "e" provided
              in the input and the variable "logite", the logit of the probabilities.}
  \item{nrowOrigData}{The size of the original sample, i.e. the length of the
                      vectors \code{e} and \code{o}.}
  \item{calibrationStat}{The value of the test's statistic.}
  \item{calibrationP}{The p-value of the test.}
  \item{m}{The degree of the polynomial at the end of the forward selection.}
  \item{fit}{An object of class \code{glm} containig the output of the fit
             of the logistic regression model at the end of the iterative
             forward selection.}
}
}
\description{
\code{givitiCalibrationTestComp} implements the computations necessary to
perform the calibration test associated to the calibration belt.
}
\details{
The calibration belt and the associated test can be used both to evaluate
the calibration of the model in external samples or in the development dataset. However,
the two cases have different requirements. When a model is evaluated on independent
samples, the calibration belt and the related test can be applied whatever is the
method used to fit the model. Conversely, they can be used on the development set
only if the model is fitted with logistic regression.
}
\examples{
e <- runif(100)
o <- rbinom(100, size = 1, prob = e)
givitiCalibrationTestComp(o, e, "external", .95, 4)
}
\seealso{
\code{\link{givitiCalibrationBelt}} and \code{\link{plot.givitiCalibrationBelt}}
 to compute and plot the calibaration belt, and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

