% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_glmstarma.R
\name{coef.glmstarma}
\alias{coef.glmstarma}
\alias{coef.dglmstarma}
\title{Extract Coefficients of glmstarma and dglmstarma Models}
\usage{
\method{coef}{glmstarma}(object, asList = FALSE)

\method{coef}{dglmstarma}(object, asList = FALSE)
}
\arguments{
\item{object}{An object of class \code{glmstarma} or \code{dglmstarma}}

\item{asList}{Logical; if \code{TRUE}, returns coefficients as a list, or otherwise as a numeric vector. Default is \code{FALSE}.}
}
\value{
A numeric vector, or a list, of model coefficients.
}
\description{
Extracts model coefficients from objects of class \code{glmstarma} and \code{dglmstarma}.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
fit <- glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"),
                 covariates = list(population = population_hungary))
coef(fit)
coef(fit, asList = TRUE)

mean_model <- list(past_obs = rep(1, 7))
dispersion_model <- list(past_obs = 1)
fit2 <- dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"),
                   dispersion_link = "log",
                   wlist = W_hungary, 
                   mean_covariates = list(population = population_hungary))
coef(fit2)
coef(fit2, asList = TRUE)
}
}
