% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{glmstarma.control}
\alias{glmstarma.control}
\title{Control Parameters for \code{glmstarma} Fitting}
\usage{
glmstarma.control(
  parameter_init = "zero",
  init_link = "first_obs",
  dispersion_est_type = "deviance",
  use_sparsity = TRUE,
  sparsity_threshold = 2/3,
  method = "nloptr",
  constrained = TRUE,
  constraint_tol = 1e-08,
  constrain_method = "sum_of_absolutes",
  gradtol = sqrt(.Machine$double.eps),
  changetol = sqrt(.Machine$double.eps),
  trace = 0L,
  fnscale = 1,
  maxit = 10000L,
  abstol = -Inf,
  reltol = sqrt(.Machine$double.eps),
  lmm = 5,
  factr = 1e+07,
  pgtol = 0
)
}
\arguments{
\item{parameter_init}{Character or list. Start values for parameter estimation. See details.}

\item{init_link}{Character or matrix, specifing how to initialize the linear process of the mean model, if regression on the feedback process is included.
\itemize{
\item \code{"first_obs"}: Use the first (transformed) observed values at each location.
\item \code{"mean"}: Use the mean of the (transformed) observed values at each location.
\item \code{"transformed_mean"}: Calculates the mean of the obsverved values at each location and transforms it by the link function.
\item \code{"zero"}: Use zero as initial value.
\item (numeric matrix) specifying starting values (rows = location, columns = time, must match maximum temporal order of model)
}}

\item{dispersion_est_type}{Character. Estimation of global dispersion parameter either based on deviance (\code{"deviance"}) or pearson residuals (\code{"pearson"}), if applicable.}

\item{use_sparsity}{Logical; whether to use sparse matrices for the neighborhood matrices.}

\item{sparsity_threshold}{Numeric in \eqn{[0, 1]}. Threshold for proportion of non-zero elements for considering neighborhood matrices as sparse (default: \code{2/3}).}

\item{method}{Character. Optimization method to be used. Options are:
\itemize{
\item \code{"nloptr"} (requires \pkg{nloptr}, default),
\item \code{"optim"} (base R \code{\link{optim}})
}}

\item{constrained}{Logical; whether to use parameter constraints ensuring a stationary solution. Only works with \code{method = "nloptr"}.}

\item{constraint_tol}{Numeric. Tolerance for constraint satisfaction.}

\item{constrain_method}{Character. Method for applying parameter constraints.
\itemize{
\item \code{"sum_of_absolutes"}: Sum of absolute values of parameters is constrained
\item \code{"absolute_sum"}: Absolute sum of parameters is constrained. (only intended for univariate models)
\item \code{"soft"}: Constraints for \code{"softplus"} and \code{"softclipping"} link functions (not available for different link functions).
}}

\item{gradtol}{Numeric. Tolerance for gradient convergence. See details.}

\item{changetol}{Numeric. Tolerance for parameter change convergence. See details.}

\item{trace}{Integer. Level of tracing output. See details.}

\item{fnscale}{Numeric. Scaling factor for the objective function. See details.}

\item{maxit}{Integer. Maximum number of iterations. See details.}

\item{abstol}{Numeric. Absolute convergence tolerance. See details.}

\item{reltol}{Numeric. Relative convergence tolerance. See details.}

\item{lmm}{Integer. Limited-memory BFGS parameter. See details.}

\item{factr}{Numeric. Factor for controlling the convergence tolerance. See details.}

\item{pgtol}{Numeric. Tolerance for projected gradient convergence. See details.}
}
\value{
A named list of control parameters
}
\description{
List of control parameters to be passed as an an argument to \code{glmstarma}.
}
\details{
This function is called internally in \code{glmstarma} to validate control parameters in the \code{control} argument.

The arguments \code{constraint_tol}, \code{gradtol}, \code{changetol}, \code{trace}, \code{fnscale}, \code{maxit}, \code{abstol}, \code{reltol}, \code{lmm}, \code{factr}, and \code{pgtol} are passed to the optimization routines and control the convergence behavior and output.
Some of these arguments are not used by all optimization methods.

The \code{optim} method uses the L-BFGS-B algorithm when non-negative parameters are required, otherwise the BFGS algorithm is used. Stationarity constraints cannot be applied when using \code{optim}.
Only if \code{method = "nloptr"} stationarity constraints are supported, and the specified \code{constrain_method} is applied. For optimization we use the SLSQP routine. The constraints implied by \code{constrain_method} are given by:
\itemize{
\item \code{"sum_of_absolutes"}: \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i} | \alpha_{i\ell} | + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j} | \beta_{j\ell} | \leq 1}
\item \code{"absolute_sum"}: \deqn{\left|\sum_{i = 1}^q\sum_{\ell = 0}^{a_i}  \alpha_{i\ell}  + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j}  \beta_{j\ell} \right| \leq 1}
\item \code{"soft"}: \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i}  \max \lbrace 0, \alpha_{i\ell} \rbrace  + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j}  \max\lbrace0, \beta_{j\ell}\rbrace \leq 1} and \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i} | \alpha_{i\ell} | < 1}
}

Start values for the optimization can be provided as a named list via \code{parameter_init} or as a character. If a named list is provided, these must match the model orders, see \code{\link{glmstarma.sim}}. Otherwise, \code{parameter_init} must be one of the following:
\itemize{
\item \code{"zero"}: All parameters initialized to (near) zero. If parameters must be non-negative a small value within the feasible region is used.
\item \code{"random"}: All parameters initialized to random values in the stationary region of the model.
}

In case of a negative binomial family, the global dispersion parameter is always estimated using dispersion_est_type = "pearson". It corresponds to the shape parameter of the negative binomial distribution.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"), 
          control = list(parameter_init = "random", init_link = "mean"))
}
}
\seealso{
\code{\link{glmstarma}}, \code{\link[nloptr]{nloptr}}, \code{\link{optim}}
}
