#' Simulated Test Data
#'
#' This dataset is a list called `testyxm` that contains two data frames: `dataOriginal` and `dataMissing`.
#'
#' @name testyxm
#' @docType data
#' @title Simulated Test Data -- `testyxm`
#'
#' @description A test list data that returns a list called `testyxm` with two components:
#' - `dataOriginal`: The original data set without missing values.
#' - `dataMissing`: The data set with artificially introduced missing values.
#'
#' @format A list with the following components:
#' \describe{
#'   \item{dataOriginal}{A data frame with several rows and columns representing various variables.}
#'   \item{dataMissing}{A data frame with missing values corresponding to the same structure as `dataOriginal`.}
#' }
#'
#' @references
#' Pradhan, V., Nychka, D., and Bandyopadhyay, S. (2024). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
#'
#' @usage data(testyxm)
#'
#' @examples
#' data(testyxm)
#' Fulldata <- testyxm$dataOriginal
#' Missdata <- testyxm$dataMissing
#'
#' @keywords datasets
"testyxm"
