% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emBinRegMixedMAR.R
\name{emBinRegMixedMAR}
\alias{emBinRegMixedMAR}
\title{Fits binary regression models with both nonignorable missing responses and missing categorical covariates.}
\usage{
emBinRegMixedMAR(
  formula,
  data,
  conflev = 0.95,
  adtnlCovforR = NULL,
  vcorctn = TRUE,
  family = binomial(link = "logit"),
  biascorrectn = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form response ~ predictors. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{Input data for fitting the model.}

\item{conflev}{a value for the confidence interval, the default is 0.95}

\item{adtnlCovforR}{an optional list of covariates to be used to fit the logistic regression \code{logit(R) ~ response+predictors+adtnlCovforR}. \code{adtnlCovforR} has to be supplied as a vector. Default is \code{NULL}.}

\item{vcorctn}{a TRUE or FALSE value, by default it is FALSE. If TRUE, it calculates a variance and standard error using Louis (1982). The default is \code{vcorctn= TRUE}.}

\item{family}{A character string specifying the type of model family. The default is \code{family=binomial (lin=logit)}.}

\item{biascorrectn}{a TRUE or FALSE value, an option for bias reduced estimates due to Firth (1993). The default is \code{biascorrectn=TRUE}.}

\item{verbose}{a TRUE or FALSE value, default is verbose = TRUE}
}
\value{
return the glm estimates
}
\description{
This function allows users to fit generalized linear models with presence of both missing responses that are nonignorable and incomplete predictors that are categorical. The model is fitted using an EM-based method, which ensures reliable parameter estimation even when dealing with missing data. For more information on the underlying methodology, please refer to Pradhan, Nychka, and Bandyopadhyay (2025).
}
\details{
The \code{family} parameter in the \code{emBinRegMixedMAR} function allows you to specify the probability distribution and link function for the response variable in the linear model. It determines the nature of the relationship between the predictors and the response variable.
The \code{family} argument is particularly important when working with binary data, where the response variable has only two possible outcomes. In such cases, you typically want to fit a logistic regression model.

Currently family=binomial is supported for binary data:

You can also specify different link functions within binomial family. The default link function is the logit function, which models the log-odds of success. Other available link functions include:
\itemize{
\item "probit" for the probit link function, which models the cumulative standard normal distribution.
\item "cloglog" for the complementary log-log link function, which models the complementary log-log of the survival function.
}

It is important to choose the appropriate \code{link} function based on the specific characteristics and assumptions of your binary data. The default "binomial" family with the logit link function is often a good starting point, but alternative link functions might be more appropriate depending on the research question and the nature of the data.
}
\examples{

\donttest{
data(testyxm) # testyxm is a list called dt
dataWithMiss <- testyxm$dataMissing
fit <- emBinRegMixedMAR(Wheeze ~ city + soc + cond,
                        data = dataWithMiss, adtnlCovforR = c("age"),
                        biascorrectn=TRUE)
#display summary of the beta estimates of the model
fit$beta

#display summary of the alpha estimates of the model used
#for non-ignorability setting of the missing responses
fit$alpha

# Examples using Firth (1993) type bias reduction. Complete case analysis or
# biascorrection=FALSE encounters separation
fit <- emBinRegMixedMAR(resp~Numnill+Numsleep+Smoke+Set+Reftime,
                        data=meningitis60ymis, biascorrectn=TRUE)
#display summary of the beta estimates of the model
fit$beta

#display summary of the alpha estimates of the model used
#for non-ignorability setting of the missing responses
fit$alpha
}
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Addressing Missing Responses and Categorical Covariates in Binary Regression Modeling: An Integrated Framework (submitted).
}
