% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_keywords.r
\name{add_control_keyword}
\alias{add_control_keyword}
\alias{add_object_keyword}
\title{Add batches of control or object keywords}
\usage{
add_control_keyword(keyword, time = "2010-01-01 2020-12-31")

add_object_keyword(keyword, time = "2010-01-01 2020-12-31")
}
\arguments{
\item{keyword}{Keywords that should be added as batch. Vector of type
\code{character} or a \code{list} of \code{character} vectors. The function also allows the
usage of codes for search topics instead of search terms.}

\item{time}{Time frame for which the batch data should be downloaded. Object
of type \code{character} that takes the from "YYYY-MM-DD YYYY-MM-DD".
Defaults to \emph{"2010-01-01 2020-12-31"}.}
}
\value{
Message that the batch has been created successfully. Batch data is
written to tables \emph{batch_keywords} and \emph{batch_time}.
Numeric vector containing the newly added batch numbers are returned.
}
\description{
The function adds one or more batches of keywords with a time period for
downloads to the database. The batches serve as input for all download and
computation functions.
}
\details{
Since Google Trends allows a maximum of five keywords for each query, batches
of control keywords can consist of up to five keywords. Since one control
keyword is added to batches of object keywords for mapping, object batch
length is limited to four keywords. When a \code{character} vector contains
more than four (five) keywords, the vector is split into four-keyword
(five-keyword) batches. A \code{list} must contain \code{character} vectors
of length four (five) or less. Each batch of keywords is combined with a time
period for which data will be downloaded. To change the time period for an
existing batch, all downloads and computations must be rerun.
}
\section{Warning}{

If you use search topics for object keywords, make sure to use search topics
for control keywords and vice versa. See Google's
\href{https://web.archive.org/web/20230117193147/https://support.google.com/trends/answer/4359550/}{FAQ}
for additional information on search topics.
}

\section{Note}{

To avoid trailing spaces \code{stringr::str_squish} is automatically
applied to all keywords.
}

\examples{
\dontrun{
add_control_keyword(
  keyword = c("gmail", "maps", "translate", "wikipedia", "youtube"),
  time = "2016-01-01 2019-12-31"
)
add_object_keyword(
  keyword = c("apple", "facebook", "google", "microsoft"),
  time = "2016-01-01 2019-12-31"
)

add_control_keyword(
  keyword = c("gmail", "maps", "news", "translate", "weather", "wikipedia", "youtube"),
  time = "2016-01-01 2019-12-31"
)
add_control_keyword(
  keyword = c("amazon", "apple", "facebook", "google", "microsoft", "netflix", "twitter"),
  time = "2016-01-01 2019-12-31"
)

add_control_keyword(
  keyword = list(
    c("gmail", "maps", "news"),
    c("translate", "weather", "wikipedia", "youtube")
  ),
  time = "2016-01-01 2019-12-31"
)
add_control_keyword(
  keyword = list(
    c("amazon", "apple", "facebook", "google"),
    c("microsoft", "netflix", "twitter")
  ),
  time = "2016-01-01 2019-12-31"
)

# search topics
add_control_keyword(
  keyword = c("\%2Fm\%2F02q_bk", "\%2Fm\%2F055t58", "\%2Fm\%2F025sndk", "\%2Fm\%2F0d07ph", "\%2Fm\%2F09jcvs"),
  time = "2016-01-01 2019-12-31"
)
# This adds the following topics: Gmail, Google Maps, Google Translate, Wikipedia, YouTube
}

}
\seealso{
\itemize{
\item \code{\link[=example_keywords]{example_keywords()}}
\item \code{\link[=example_time]{example_time()}}
\item \code{\link[stringr:str_trim]{stringr::str_squish()}}
}
}
