% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-meter.R
\name{Meter}
\alias{Meter}
\title{Create \code{Meter} Object}
\usage{
Meter(
  number,
  unit,
  bar = NULL,
  actual_number = NULL,
  actual_unit = NULL,
  invisible = NULL
)
}
\arguments{
\item{number}{A positive integer to represent the upper numeral of the
time signature, which indicates how many beats each measure has.}

\item{unit}{A single integer which can be
1, 2, 4, 8, 16, 32 or 64. It represents the lower numeral of the
time signature, which indicates the duration of one single beat.}

\item{bar}{Optional. A positive integer, which indicates the number of
the measure where to add the time signature. By default, the
time signature will be added at the first measure.}

\item{actual_number, actual_unit}{Optional. They define the actual
time signature rather than the one that appears on the score. Usually
used to create a pickup measure. By default, they are the
same as \code{number} and \code{unit}.}

\item{invisible}{Optional. A single logical, which indicates whether to
show the time signature on the score. Usually used to create a
pickup measure. The default value is \code{FALSE}.}
}
\value{
A list of class \code{Meter}.
}
\description{
Create a \code{Meter} object to represent a time signature.
}
\examples{
# Create a 3/4 time signature
meter <- Meter(3, 4)

# Add it to a `Music`
music <- Music() + Line(c("C4", "D4", "E4")) + meter
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Meter} to a \code{Music} object.
}
