% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise.R
\name{stepwise}
\alias{stepwise}
\title{Select the explanatory variables, the number of mixture components and
estimate the parameters of a conditional Gaussian mixture model}
\usage{
stepwise(
  gmm,
  data,
  y = rownames(gmm$mu)[1],
  x_cand = setdiff(colnames(data), y),
  score = "bic",
  add = TRUE,
  remove = TRUE,
  min_x = 0,
  max_x = Inf,
  max_iter_step = 10,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{gmm}{An initial object of class \code{gmm}.}

\item{data}{A data frame or numeric matrix containing the data used in the
stepwise algorithm. Its columns must explicitly be named after the variables
of \code{gmm} and the candidate explanatory variables, and must not contain
missing values.}

\item{y}{A character vector containing the dependent variables (by default
the first variable of \code{gmm}).}

\item{x_cand}{A character vector containing the candidate explanatory
variables for addition or removal (by default all the column names of
\code{data} except \code{y}). If variables already in \code{gmm} are not
candidates, they cannot be removed.}

\item{score}{A character string (\code{"aic"}, \code{"bic"} or
\code{"loglik"}) corresponding to the scoring function.}

\item{add}{A logical value indicating whether add operations are allowed (if
\code{FALSE}, no variable can be added).}

\item{remove}{A logical value indicating whether remove operations are
allowed (if \code{FALSE}, no variable can be removed).}

\item{min_x}{A non-negative integer corresponding to the minimum number of
explanatory variables.}

\item{max_x}{A non-negative integer corresponding to the maximum number of
explanatory variables.}

\item{max_iter_step}{A non-negative integer corresponding to the maximum
number of iterations.}

\item{verbose}{A logical value indicating whether iterations in progress
are displayed.}

\item{\dots}{Additional arguments passed to function \code{\link{smem}}.}
}
\value{
A list with elements:
\item{gmm}{The final \code{gmm} object.}
\item{posterior}{A numeric matrix containing the posterior probabilities for
each observation.}
\item{seq_score}{A numeric vector containing the sequence of scores measured
initially and after each iteration.}
\item{seq_oper}{A character vector containing the sequence of add and remove
operations performed at each iteration.}
}
\description{
This function selects the explanatory variables, the number of mixture
components and estimates the parameters of a conditional Gaussian mixture
model using a stepwise algorithm. At the first iteration, the SMEM algorithm
is performed to update the number of components and the parameters of the
initial model. Then each following iteration consists in adding or removing a
candidate explanatory variable, before re-estimating the model with the SMEM
algorithm. The selected add or remove operation is the one that maximizes a
conditional scoring function (after the re-estimation process). The stepwise
algorithm stops if none of the candidate operations improves the score.
}
\examples{
\donttest{
data(data_body)
gmm_1 <- add_var(NULL, "WAIST")
res_step <- stepwise(gmm_1, data_body, verbose = TRUE, max_comp = 3)}

}
\seealso{
\code{\link{em}}, \code{\link{smem}}
}
