% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brant.R
\name{brant.test}
\alias{brant.test}
\title{Brant Test of the Proportional Odds Assumption}
\usage{
brant.test(model, global= FALSE, call = FALSE)
}
\arguments{
\item{model}{a single model object to be tested.}

\item{global}{default to FALSE. When TRUE, a global test is made for the factor
variables instead of the individual factor levels.}

\item{call}{when TRUE the model call is printed alongside test results.}
}
\value{
\item{model}{call of the model tested}

\item{df}{the degrees of freedom}

\item{global}{logical vector of TRUE or FALSE}

\item{modeltype}{character vector of the class of model tested}

\item{Terms}{original model terms}

\item{vnames}{character vector of variable names used in the model}

\item{chisq}{realized values of the chi-square statistic}

\item{rdf}{residual degrees of freedom}

\item{rDev}{residual deviance}

\item{prob}{the p-values of test}

\item{call}{a logical vector}
}
\description{
Provides the means of testing the parallel regression assumption
in the ordinal regression  models. Also available is the likelihood ratio test,
LR.test().
}
\details{
The parallel regression assumption for the ordinal regression  model
can be tested With this function. The brant test (Brant, 1990) is currently
available for objects of class: serp(), clm(), polr() and vglm(). Objects of class
serp() should have the \code{slope} argument set to 'parallel', while objects of
class vglm() should have the \code{model} argument TRUE, if not, the model is
automatically updated to include the object 'model'. Moreover, family in
vglm() must be either "cumulative" or "propodds", with the parallel argument TRUE.
}
\examples{

require(serp)

set.seed(1)
n <- 200
y <- ordered(rbinom(n, 2, 0.5))
x1 <- factor(rbinom(n, 2, 0.7))
x2 <- runif(n)

## proportional odds model
sp <- serp(y ~ x1 * x2, link = "logit", slope = "parallel", reverse = TRUE)

brant.test(sp)
brant.test(sp, global = TRUE, call=TRUE)

}
\references{
Brant, R. (1990). Assessing proportionality in the proportional odds model
    for ordinal logistic regression. \emph{Biometrics}, 46, 1171-1178.
}
\seealso{
\code{\link{LR.test}}, \code{\link{hosmerlem}}, \code{\link{lipsitz}},
 \code{\link{pulkroben}}
}
