% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalGLM.R
\name{NormalGLM}
\alias{NormalGLM}
\title{Generalized linear model with normal distribution}
\description{
This class represents a generalized linear model with normal
distribution. It inherits from \link{GLM} and implements its functions that,
for example, evaluate the conditional density and distribution functions.
}
\examples{
# Use the built-in cars dataset
x <- datasets::cars$speed
y <- datasets::cars$dist
data <- dplyr::tibble(x=x, y=y)

# Create an instance of a NormalGLM
model <- NormalGLM$new()

# Fit a Normal GLM to the cars dataset
model$fit(data, params_init = list(beta=3, sd=2), inplace=TRUE)
params_opt <- model$get_params()

# Plot the resulting regression function
plot(datasets::cars)
abline(a = 0, b = params_opt$beta)

# Generate a sample for y for given x following the same distribution
x.new <- seq(min(x), max(x), by=2)
y.smpl <- model$sample_yx(x.new)
points(x.new, y.smpl, col="red")

# Evaluate the conditional density, distribution, quantile and regression
# function at given values
model$f_yx(y.smpl, x.new)
model$F_yx(y.smpl, x.new)
model$F1_yx(y.smpl, x.new)
y.pred <- model$mean_yx(x.new)
points(x.new, y.pred, col="blue")
}
\section{Super classes}{
\code{\link[gofreg:ParamRegrModel]{gofreg::ParamRegrModel}} -> \code{\link[gofreg:GLM]{gofreg::GLM}} -> \code{NormalGLM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NormalGLM-fit}{\code{NormalGLM$fit()}}
\item \href{#method-NormalGLM-f_yx}{\code{NormalGLM$f_yx()}}
\item \href{#method-NormalGLM-F_yx}{\code{NormalGLM$F_yx()}}
\item \href{#method-NormalGLM-F1_yx}{\code{NormalGLM$F1_yx()}}
\item \href{#method-NormalGLM-sample_yx}{\code{NormalGLM$sample_yx()}}
\item \href{#method-NormalGLM-clone}{\code{NormalGLM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="get_params"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-get_params'><code>gofreg::ParamRegrModel$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="set_params"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-set_params'><code>gofreg::ParamRegrModel$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="GLM" data-id="initialize"><a href='../../gofreg/html/GLM.html#method-GLM-initialize'><code>gofreg::GLM$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="GLM" data-id="mean_yx"><a href='../../gofreg/html/GLM.html#method-GLM-mean_yx'><code>gofreg::GLM$mean_yx()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-fit"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-fit}{}}}
\subsection{Method \code{fit()}}{
Calculates the maximum likelihood estimator for the model
parameters based on given data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$fit(
  data,
  params_init = private$params,
  loglik = loglik_xy,
  inplace = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{tibble containing the data to fit the model to}

\item{\code{params_init}}{initial value of the model parameters to use for the
optimization (defaults to the fitted parameter values)}

\item{\code{loglik}}{\verb{function(data, model, params)} defaults to \code{\link[=loglik_xy]{loglik_xy()}}}

\item{\code{inplace}}{\code{logical}; if \code{TRUE}, default model parameters are set
accordingly and parameter estimator is not returned}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MLE of the model parameters for the given data, same shape as
\code{params_init}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-f_yx"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-f_yx}{}}}
\subsection{Method \code{f_yx()}}{
Evaluates the conditional density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$f_yx(t, x, params = private$params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{value(s) at which the conditional density shall be evaluated}

\item{\code{x}}{matrix of covariates, each row representing one sample}

\item{\code{params}}{model parameters to use (\code{list()} with tags beta and sd),
defaults to the fitted parameter values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value(s) of the conditional density function, same shape as \code{t}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-F_yx"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-F_yx}{}}}
\subsection{Method \code{F_yx()}}{
Evaluates the conditional distribution function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$F_yx(t, x, params = private$params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{value(s) at which the conditional distribution shall be
evaluated}

\item{\code{x}}{matrix of covariates, each row representing one sample}

\item{\code{params}}{model parameters to use (\code{list()} with tags beta and sd),
defaults to the fitted parameter values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value(s) of the conditional distribution function,  same shape as
\code{t}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-F1_yx"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-F1_yx}{}}}
\subsection{Method \code{F1_yx()}}{
Evaluates the conditional quantile function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$F1_yx(t, x, params = private$params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{value(s) at which the conditional quantile function shall be
evaluated}

\item{\code{x}}{matrix of covariates, each row representing one sample}

\item{\code{params}}{model parameters to use (\code{list()} with tags beta and sd),
defaults to the fitted parameter values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value(s) of the conditional quantile function, same shape as
\code{t}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-sample_yx"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-sample_yx}{}}}
\subsection{Method \code{sample_yx()}}{
Generates a new sample of response variables with the same
conditional distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$sample_yx(x, params = private$params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{matrix of covariates, each row representing one sample}

\item{\code{params}}{model parameters to use (\code{list()} with tags beta and sd),
defaults to the fitted parameter values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
vector of sampled response variables, same length as \code{nrow(x)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalGLM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NormalGLM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalGLM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
