% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules_fn.R
\name{add_module}
\alias{add_module}
\title{Create a module}
\usage{
add_module(
  name,
  pkg = get_golem_wd(),
  open = TRUE,
  dir_create = TRUE,
  fct = NULL,
  utils = NULL,
  r6 = NULL,
  js = NULL,
  js_handler = NULL,
  export = FALSE,
  module_template = golem::module_template,
  with_test = FALSE,
  ...
)
}
\arguments{
\item{name}{The name of the module.}

\item{pkg}{Path to the root of the package. Default is \code{get_golem_wd()}.}

\item{open}{Should the created file be opened?}

\item{dir_create}{Creates the directory if it doesn't exist, default is \code{TRUE}.}

\item{fct}{If specified, creates a \code{mod_fct} file.}

\item{utils}{If specified, creates a \code{mod_utils} file.}

\item{r6}{If specified, creates a \code{mod_class} file.}

\item{js, js_handler}{If specified, creates a module related JavaScript file.}

\item{export}{Should the module be exported? Default is \code{FALSE}.}

\item{module_template}{Function that serves as a module template.}

\item{with_test}{should the module be created with tests?}

\item{...}{Arguments to be passed to the \code{module_template} function.}
}
\value{
The path to the file, invisibly.
}
\description{
This function creates a module inside the \verb{R/} folder, based
on a specific module structure. This function can be used outside
of a \code{{golem}} project.
}
\note{
This function will prefix the \code{name} argument with \code{mod_}.
}
\seealso{
\code{\link[=module_template]{module_template()}}
}
