% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt.R
\name{polyline_wkt}
\alias{polyline_wkt}
\title{Polyline WKT}
\usage{
polyline_wkt(obj)
}
\arguments{
\item{obj}{\code{sfencoded} object or \code{encoded_column} of encoded polylines}
}
\value{
well-known text representation of the encoded polylines
}
\description{
Converts encoded polylines into well-known text.
}
\details{
'Polylines' refers to lat/lon coordinates encoded into strings using Google's 
polyline encoding algorithm.

The function assumes Google Web Mercator projection (WSG 84 / EPSG:3857 / EPSG:900913)
for inputs and outputs.
}
\note{
This will not work if you have specified \code{strip = TRUE} for \code{encode()}
}
\examples{
\dontrun{

library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))

## encode to polylines
enc <- encode(nc)

## convert encoded lines to well-known text
wkt <- polyline_wkt(enc)

}

}
