% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containers.R
\name{gtm_containers_get}
\alias{gtm_containers_get}
\title{Gets the metadata for a single container in GTM}
\usage{
gtm_containers_get(account_id, container_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}
}
\description{
This returns a list containing all the metadata about a single container.
If you want to get the information for all containers, use \code{gtm_containers_list}
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321
container <- gtm_containers_get(accountId, containerId)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/get}

Other container functions: 
\code{\link{gtm_containers_create}()},
\code{\link{gtm_containers_delete}()},
\code{\link{gtm_containers_list}()},
\code{\link{gtm_containers_update}()}
}
\concept{container functions}
