% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{ClassifyGenes}
\alias{ClassifyGenes}
\title{Build the type column for the gene info table.}
\usage{
ClassifyGenes(
  ...,
  use.default = TRUE,
  drop.levels = TRUE,
  name.unknown = "Unknown"
)
}
\arguments{
\item{...}{additional functions to define types (see details)}

\item{use.default}{if TRUE, use the default type inference (priority after the user defined ones); see details}

\item{drop.levels}{if TRUE, drop unused types from the factor that is generated}

\item{name.unknown}{the type to be used for all genes where no type was identified}
}
\value{
a function that takes the original \link{GeneInfo} table and adds the Type column
}
\description{
Returns a function to be used as \code{classify.genes} parameter for \code{\link{ReadGRAND}}.
}
\details{
This function returns a function. Usually, you do not use it yourself but \code{ClassifyGenes} is usually as \code{classify.genes} parameter
for  \code{\link{ReadGRAND}} to build the \emph{Type} column in the \code{\link{GeneInfo}} table. See the example
to see how to use it directly.

Each ... parameter must be a function that receives the gene info table and must return a logical vector, indicating for each row
in the gene info table, whether it matches to a specific type. The name of the parameter is used as the type name.

If a gene matches to multiple type, the first function returning TRUE for a row in the table is used.

By default, this function will recognize mitochondrial genes (MT prefix of the gene symbol), ERCC spike-ins,
and Ensembl gene identifiers (which it will call "cellular"). These three are the last functions to be checked (in case a user defined type via ...) also
matches to, e.g., an Ensembl gene).
}
\examples{

viral.genes <- c('ORF3a','E','M','ORF6','ORF7a','ORF7b','ORF8','N','ORF10','ORF1ab','S')
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate),
                  classify.genes=ClassifyGenes(`SARS-CoV-2`=
                             function(gene.info) gene.info$Symbol \%in\% viral.genes),
                  verbose=TRUE)
table(GeneInfo(sars)$Type)

fun<-ClassifyGenes(viral=function(gene.info) gene.info$Symbol \%in\% viral.genes)
table(fun(GeneInfo(sars)))

}
\seealso{
\link{ReadGRAND}
}
\concept{load}
