% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_compar.R
\name{link_compar}
\alias{link_compar}
\title{Compare two link sets created in a Graphab project}
\usage{
link_compar(
  proj_name,
  linkset1,
  linkset2,
  buffer_width = 200,
  min_length = NULL,
  proj_path = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is. It can be created with \code{\link{graphab_project}}}

\item{linkset1}{A character string indicating the name of the first link set
involved in the comparison. The link set has to be present in the project
and can be created with \code{\link{graphab_link}}.}

\item{linkset2}{A character string indicating the name of the second link set
involved in the comparison. The link set has to be present in the project
and can be created with \code{\link{graphab_link}}.}

\item{buffer_width}{(default=200) An integer or numeric value
indicating the width of the buffer created in each side of the links prior
to spatial intersection. It is expressed in meters.}

\item{min_length}{(optional, default=NULL) An integer or numeric value
indicating the minimum length in meters of the links to be compared. Links
whose length is larger than \code{min_length} will be ignored in
the comparison.}

\item{proj_path}{(optional, default=NULL) A character string indicating the
path to the directory that contains the project directory. It should be used
when the project directory is not in the current working directory.
Default is NULL. When 'proj_path = NULL', the project directory is equal
to \code{getwd()}.}
}
\description{
The function compares two link sets created in a Graphab project
both quantitatively and spatially.
}
\details{
The function compares two link sets linking the same habitat patches
of the Graphab project but computed using different cost scenarios. It
creates a buffer in each side of every link and then overlaps every link
in linkset1 with the same link in linkset2. It returns the area of both
buffered links and the area of their intersection. It also computes the
Mantel correlation coefficient between the cost distances associated to the
same links in both linksets.
}
\examples{
\dontrun{
link_compar(proj_name = "grphb_ex",
              linkset1 = "lcp1",
              linkset2 = "lcp2"
              buffer_width = 200)
}
}
\author{
P. Savary
}
\keyword{internal}
