% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphClustering.R
\name{graphClustering}
\alias{graphClustering}
\title{Hierarchical graph clustering algorithm}
\usage{
graphClustering(
  allAdj,
  hyperParam = list(alpha = 0.5, eta = 0.5, zeta = 0.5, lambda = 0.5),
  returnInitial = FALSE,
  nbClust = NULL,
  nbSBMBlocks = Inf,
  initCountStat = NULL,
  initDeltaICL = NULL,
  nbCores = 1
)
}
\arguments{
\item{allAdj}{list of adjacency matrices}

\item{hyperParam}{hyperparameters of prior distributions}

\item{returnInitial}{Boolean. Return SBM parameters from initialization or not. Default is FALSE.}

\item{nbClust}{desired number of clusters. Default NULL, which means that the
number of clusters is chosen automatically via the ICL criterion}

\item{nbSBMBlocks}{upper bound for the number of blocks in the SBMs of the mixture components. Default is Inf}

\item{initCountStat}{initial count statistics may be provided to the method. Default is NULL.}

\item{initDeltaICL}{initial deltaICL-matrix may be provided to the method. Default is NULL.}

\item{nbCores}{number of cores for parallelization}
}
\value{
list with the following fields: $graphGroups is the graph clustering,
$nodeClusterings is a list with the node labels for each networks,
$thetaMixSBM contains the estimated parameter of the mixture of SBMs,
$ICL is the value of the ICL criterion of the final clustering,
$histGraphGroups traces the history of the cluster aggregations,
$histDeltaICL traces the evolution of the deltaICL value,
$histFusedClusters traces the history of the aggregated cluster numbers
}
\description{
Applies the hierarchical graph clustering algorithm to a collection of networks
and fits a finite mixture model of stochastic block models to the data
}
\examples{
theta <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
obs <- rCollectSBM(rep(10,4), theta)$listGraphs
res <- graphClustering(obs, nbCores=1)
}
