% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators-edge.R
\name{edgeGenerators}
\alias{edgeGenerators}
\alias{addEdgesComplete}
\alias{addEdgesGrid}
\alias{addEdgesOnion}
\alias{addEdgesDelauney}
\alias{addEdgesWaxman}
\alias{addEdgesGilbert}
\alias{addEdgesErdosRenyi}
\alias{addEdgesSpanningTree}
\title{Edge generators.}
\usage{
addEdgesComplete(graph, ...)

addEdgesGrid(graph, ...)

addEdgesOnion(graph, ...)

addEdgesDelauney(graph, ...)

addEdgesWaxman(graph, alpha = 0.5, beta = 0.5, ...)

addEdgesGilbert(graph, p, ...)

addEdgesErdosRenyi(graph, m, ...)

addEdgesSpanningTree(graph, runs = 1L, ...)
}
\arguments{
\item{graph}{[\code{\link{grapherator}}]\cr
Graph.}

\item{...}{[any]\cr
Not used at the moment.}

\item{alpha}{[\code{numeric(1)}]\cr
Positive number indicating the average degree of nodes in the Waxman model.
Default is 0.5.}

\item{beta}{[\code{numeric(1)}]\cr
Positive number indicating the scale between short and long edges in the Waxman model.
Default is 0.5.}

\item{p}{[\code{numeric(1)}]\cr
Probability for each edge \eqn{(v_i, v_j), i, j = 1, \ldots, n} to be added
for Gilbert graphs.}

\item{m}{[\code{integer(1)}]\cr
Number of edges to sample for Erdos-Renyi graphs.
Must be at most \eqn{n(n-1)/2} where \eqn{n} is the number of nodes of \code{graph}.}

\item{runs}{[\code{integer(1)}]\cr
Number of runs to perform by \code{\link{addEdgesSpanningTree}}.
Default is \code{1}.}
}
\value{
[\code{list}] List with components:
\describe{
  \item{adj.mat \code{matrix}}{Adjacency matrix.}
  \item{generator [\code{character(1)}]}{String description of the generator used.}
}
}
\description{
Function to add edges into a graph. The following methods
are implemented so far:
\describe{
  \item{\code{addEdgesComplete}}{Generates a simple complete graph. I.e., an edge
  exists between each two nodes. However, no self-loops or multi-edges are included.}
  \item{\code{addEdgesGrid}}{Only usefull if nodes are generated via \code{\link{addNodesGrid}}.
  This method generates a Manhattan-like street network.}
  \item{\code{addEdgesOnion}}{This method determines the nodes on the convex hull
  of the node cloud in the euclidean plane and adds edges between neighbour nodes.
  Ignoring all nodes on the hull, this process is repeated iteratively resulting in an
  onion like peeling topololgy. Note that the graph is not connected! In order to
  ensure connectivity, another edge generator must be applied in addition, e.g.,
  \code{addEdgesSpanningTree}.}
  \item{\code{addEdgesDelauney}}{Edges are determined by means of a Delauney triangulation
  of the node coordinates in the Euclidean plane.}
  \item{\code{addEdgesWaxman}}{Edges are generated using the Waxman-model, i.e., the
  probability \eqn{p_{ij}} for the edge \eqn{(i, j)} is given by
  \deqn{p_{ij} = \alpha e^{-\beta d_{ij}}},
  where \eqn{\alpha, \beta \geq 0} are control parameters and \eqn{d_{ij}} is the
  Euclidean distance of the nodes \eqn{i} and \eqn{j}.}
  \item{\code{addEdgesSpanningTree}}{A minimum spanning tree is computed based on
  a complete random weight matrix. All edges of the spanning tree are added. If \code{runs}
  is greater 1, the process is repeated for \code{runs}. However, already added edges are
  ignored in subsequent runs.
  This method is particularly useful to assist probablistic methods, e.g., Waxman model,
  in order to generate connected graphs.}
  \item{\code{addEdgesGilbert}}{Use Gilbert-model to generate edges. I.e., each edge is
  added with probability \eqn{p \in [0, 1]}.}
  \item{\code{addEdgesErdosRenyi}}{In total \eqn{m \leq n(n-1)/2} edges are added at random.}
}
}
\details{
Currently all edge generators create symmetric edges only.
}
\note{
These functions are not meant to be called directly. Instead, they need
to be assigned to the \code{generator} argument of \code{\link{addEdges}}.
}
