% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_structure.R
\name{emst}
\alias{emst}
\title{Fitting extremal minimum spanning tree}
\usage{
emst(data, p = NULL, method = c("vario", "ML", "chi"), cens = FALSE)
}
\arguments{
\item{data}{Numeric \nxd matrix, where \code{n} is the
number of observations and \code{d} is the dimension.}

\item{p}{Numeric between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} are already on multivariate Pareto scale. Else,
\code{p} is used as the probability in the function \code{\link[=data2mpareto]{data2mpareto()}}
to standardize the \code{data}.}

\item{method}{One of \verb{"vario", "ML", "chi"}.
Default is \code{method = "vario"}.}

\item{cens}{Logical. This argument is considered only if \code{method = "ML"}.
If \code{TRUE}, then censored likelihood contributions are used for
components below the threshold. By default, \code{cens = FALSE}.}
}
\value{
List consisting of:
\item{\code{graph}}{An \code{\link[igraph:make_graph]{igraph::graph}} object. The fitted minimum spanning tree.}
\item{\code{Gamma}}{
Numeric \dxd estimated variogram matrix \eGamma
corresponding to the fitted minimum spanning tree.
}
}
\description{
Fits an extremal minimum spanning tree, where the edge weights are:
\itemize{
\item negative maximized log-likelihoods of the bivariate Huesler-Reiss distributions,
if \code{method = "ML"}. See \insertCite{eng2019;textual}{graphicalExtremes} for details.
\item empirical extremal variogram, if \code{method = "vario"}. See \insertCite{eng2020;textual}{graphicalExtremes} for details.
\item empirical extremal correlation, if \code{method = "chi"}. See \insertCite{eng2020;textual}{graphicalExtremes} for details.
}
}
\examples{
## Fitting a 4-dimensional HR minimum spanning tree
my_graph <- igraph::graph_from_adjacency_matrix(
  rbind(
    c(0, 1, 0, 0),
    c(1, 0, 1, 1),
    c(0, 1, 0, 0),
    c(0, 1, 0, 0)
  ),
  mode = "undirected"
)
n <- 100
Gamma_vec <- c(.5, 1.4, .8)
complete_Gamma(Gamma = Gamma_vec, graph = my_graph) ## full Gamma matrix

set.seed(123)
my_data <- rmpareto_tree(n, "HR", tree = my_graph, par = Gamma_vec)
my_fit <- emst(my_data, p = NULL, method = "ML", cens = FALSE)
}
\references{
\insertAllCited{}
}
\seealso{
Other structure estimation methods:
\code{\link{data2mpareto}()},
\code{\link{eglatent}()},
\code{\link{eglearn}()},
\code{\link{fit_graph_to_Theta}()}
}
\concept{structureEstimation}
