% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_szgaGA.R
\name{szgaGA}
\alias{szgaGA}
\title{Sample size optimization using graphical approach in clinical trial design with three hypotheses}
\usage{
szgaGA(
  alpha,
  betaVec,
  deltaVec,
  cVec,
  rhoMat,
  lower = c(1, rep(1e-06, 2), rep(1e-06, 3)),
  upper = c(10000, rep(1 - 1e-06, 2), rep(1 - 1e-06, 3)),
  gaIter = c(20, 20),
  penPara = 0.1,
  seed = 2022
)
}
\arguments{
\item{alpha}{a value of overall type I error rate}

\item{betaVec}{a vector of one minus marginal powers for testing H1, H2 and H3, respectively}

\item{deltaVec}{a vector of effect sizes for testing H1, H2 and H3, respectively}

\item{cVec}{a vector of coefficients. When testing continuous endpoints, these coefficients are exactly one. When testing binary endpoints, the values are roughly one but not exactly one}

\item{rhoMat}{a matrix of the correlation coefficients among three hypotheses}

\item{lower}{a vector of lower limit of sample size n, initial weights w1 and w2, and transition probabilities g12, g23 and g31}

\item{upper}{a vector of upper limit of sample size n, initial weights w1 and w2, and transition probabilities g12, g23 and g31}

\item{gaIter}{a vector of two numbers. The first one is the parameter maxiter of the ga function, and the second one is the parameter run of the ga function}

\item{penPara}{a number of penalization parameter for optimization to balance the sample size requirement and the power requirement}

\item{seed}{a number of the seed of the random number generator}
}
\value{
a vector of six numbers: the optimal sample size \code{n}, initial weights \code{w1} and \code{w2}, and transition probabilities \code{g12}, \code{g23} and \code{g31}
}
\description{
This function computes the optimal design using graphical approach along with the minimum sample size when three hypotheses are considered in a clinical trial.
}
\details{
R package \code{GA} is used for Genetic Algorithms.
}
\examples{
start <- Sys.time()
szgaGA(alpha = 0.025, betaVec = c(0.15, 0.20, 0.10),
       deltaVec = c(0.1111952, 0.1037179, 0.1182625),
       cVec = c(1.003086, 1.002686, 1.00349),
       rhoMat = matrix(c(1,0.5,0.8, 0.5,1,0.6, 0.8,0.6,1), nrow = 3, byrow = TRUE),
       lower = c(750, rep(0.01, 2), rep(0.01, 3)),
       upper = c(850, rep(0.99, 2), rep(0.99, 3)),
       gaIter = c(10, 5),
       penPara = 0.015,
       seed = 234)
end <- Sys.time()
data.frame(time = end - start)


}
\references{
Zhang, F. and Gou, J. (2023). Sample size optimization for clinical trials using graphical approaches for multiplicity adjustment, Technical Report.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
\author{
Jiangtao Gou
}
