% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gremlinControl.R
\name{gremlinControl}
\alias{gremlinControl}
\title{Advanced Options for Mixed-effect modeling functions.}
\usage{
gremlinControl(
  cctol = c(5e-04, 1e-05, 0.01, NULL),
  ezero = 1e-08,
  einf = 1e+30,
  step = 0.3,
  h = .Machine$double.eps^(1/3),
  lambda = FALSE,
  algorithm = NULL,
  algArgs = list()
)
}
\arguments{
\item{cctol}{Convergence criteria tolerances (Meyer 2007, 2019). See details
about the convergence checks in \code{\link[gremlin]{ccFun}}.}

\item{ezero}{Effective zero to be used, values less than this number are
treated as zero and fixed to this value.}

\item{einf}{Effective infinite value to be used, values are limited to a
to this variable as a maximum.}

\item{step}{A \code{numeric} value for scaling the proposed parameter updates.}

\item{h}{A \code{numeric} value for finite difference algorithm of partial
first derivatives for the likelihood function. Specifies the amount to add
to parameter value to calculate the change in log-likelihood.}

\item{lambda}{A \code{logical} indicating whether a residual variance should
be factored out of the mixed model equations.}

\item{algorithm}{A \code{character} naming the function to use to decide
subsequent parameters in the REML iterations.}

\item{algArgs}{A \code{list} of function arguments to be given to functions
named in the \code{algorithm} argument.}
}
\value{
A \code{list} of class \code{gremlinControl} to be used by
  \code{gremlinSetup} and later functions when fitting the model.
}
\description{
Change default settings for gremlin models.
}
\examples{
  str(gremlinControl())

}
\references{
Meyer, K. 2007. WOMBAT - a tool for mixed model analyses in quantitative
  genetics by restricted maximum likelihood (REML). Journal of Zhejiang
  University SCIENCE B 8(11):815-821.

  Meyer, K. 2019. WOMBAT A program for mixed model analyses by restricted
  maximum likelihood. User Notes. 27 September 2019.
}
\author{
\email{matthewwolak@gmail.com}
}
