% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{generate_proximities}
\alias{generate_proximities}
\title{Generate a Proximity Matrix}
\usage{
generate_proximities(sociomatrix, mode = c("ogpv", "oppv",
  "sconductivity"), p = Inf, node_costs = NULL, odds_scale = 1,
  odds_scale_by_node = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{mode}{a selection of \code{'ogpv'}, \code{'oppv'}, or \code{'sconductivity'}}

\item{p}{if \code{mode} is \code{'ogpv'}, determines 'p-norm' parameter for 
generalized path value calculation.}

\item{node_costs}{if \code{mode} is \code{'ogpv'}, assigns transmission costs to
vertices within the sociomatrix.}

\item{odds_scale}{if \code{mode} is \code{'oppv'}, sets a global transfer odds 
scale for probabilistic path value calculation.}

\item{odds_scale_by_node}{if \code{mode} is \code{'oppv'}, sets a transfer odds 
scale for each node in a probabilistic path value calculation.}
}
\description{
Generates a proximity matrix in one of three modes:
\describe{
  \item{\code{'ogpv'}}{Optimal Generalized Path Value. Entry \code{i,j} of the 
    proximity matrix will equal the optimal 'gpv' among all paths connecting node 
    \code{i} to node \code{j}.}
  \item{\code{'oppv'}}{Optimal Probabilistic Path Value. Entry \code{i,j} of the 
    proximity matrix will equal the optimal 'ppv' among all paths connecting node 
    \code{i} to node \code{j}.}
  \item{\code{'sconductivity'}}{Social Conductivity (Random Walk Probability). If 
    each tie strength recorded in \code{sociomatrix} is taken to be analogous to the 
    conductivity of an electrical component, \code{i,j} of the proximity matrix 
    will equal total conductivity of all paths from node \code{i} to node \code{j}.}
}
}
\examples{
## Generate a proximity matrix in each mode
## Optimal Generalized Path Value
generate_proximities(YangKnoke01, mode = "ogpv", p = Inf, node_costs = c(1,3,3,2,1))

## Optimal Probabilistic Path Value
generate_proximities(YangKnoke01, mode = "oppv", odds_scale = 2)

## Sconductivity
generate_proximities(YangKnoke01, mode = "sconductivity")

}
\seealso{
\code{\link{gpv}}, \code{\link{ppv}}
}
