% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eng_gretl.R
\name{eng_gretl}
\alias{eng_gretl}
\title{Add \code{gretl} as knit-engine to knitr package}
\usage{
eng_gretl(options)
}
\arguments{
\item{options}{Chunk options, as provided by \code{knitr} during chunk execution. Chunk option for this is \code{gretl}}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) codes
}
\description{
This package runs on top of knitr to facilitate communication with \code{gretl}. Run \code{gretl} scripts from R, R Markdown and Quarto document.
}
\details{
The \code{gretl} engine can be activated via\preformatted{knitr::knit_engines$set(gretl = gretlR::eng_gretl)
}

This will be set within an R Markdown document's setup chunk.
}
\examples{
knitr::knit_engines$set(gretl = gretlR::eng_gretl)
library(gretlR)
}
\references{
Bob Rudis (2015).Running Go language chunks in R Markdown (Rmd) files. Available at:  https://gist.github.com/hrbrmstr/9accf90e63d852337cb7

Yihui Xie (2019). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.24.

Yihui Xie (2015) Dynamic Documents with R and knitr. 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963

Yihui Xie (2014) knitr: A Comprehensive Tool for Reproducible Research in R. In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
}
\seealso{
Other important functions: 
\code{\link{exec_gretl}()},
\code{\link{exec_inp}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{include_tex}()},
\code{\link{write_inp}()}
}
\author{
\href{https://smati.com.ng}{Sagiru Mati}, \href{https://orcid.org/0000-0003-1413-3974}{ORCID: 0000-0003-1413-3974}
\itemize{
\item \href{https://yumsuk.edu.ng}{Yusuf Maitama Sule (Northwest) University Kano, Nigeria}
\item \href{https://academy.smati.com.ng}{SMATI Academy}
}
}
\concept{important functions}
\keyword{documentation}
