% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmforest-varimp-final.R
\name{varimp}
\alias{varimp}
\title{Calculate Variable Importance for GRM Forest}
\usage{
varimp(forest, method = "permutation", verbose = FALSE, seed = NULL)
}
\arguments{
\item{forest}{A \code{grmforest} object created by \code{grmforest()}.}

\item{method}{Importance calculation method (currently only "permutation").}

\item{verbose}{Logical indicating whether to show progress messages.}

\item{seed}{Random seed for reproducibility.}
}
\value{
A named numeric vector of importance scores with class \code{varimp}.
Higher values indicate more important variables.
}
\description{
Computes permutation importance scores for variables in a GRM forest using
out-of-bag samples. Importance is measured by the decrease in log-likelihood
when a variable's values are permuted.
}
\examples{
\donttest{
library(grmtree)
library(hlt)
data("asti", package = "hlt")
asti$resp <- data.matrix(asti[, 1:4])

## Fit the GRM Forest
forest <- grmforest(resp ~ gender + group, data = asti,
control = grmforest.control(n_tree = 5))
  importance <- varimp(forest)

## Print and plot the variable importance scores
print(importance)
plot(importance)
}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests, \code{\link{grmforest.control}}
creates a control object for \code{grmforest}, \code{\link{plot.varimp}} creates
a bar plot of variable importance scores
}
