% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{plot_mapping}
\alias{plot_mapping}
\title{Plot spatially interpolated tree-ring growth maps}
\usage{
plot_mapping(
  mapping_results,
  crs.src = "EPSG:4326",
  parms.out = c("csv", "tif", "png", "gif"),
  dir.shp = NULL,
  dir.out = NULL,
  animation_fps = 1,
  ...
)
}
\arguments{
\item{mapping_results}{A list returned by \code{\link{CFS_mapping}} containing
spatially interpolated rasters by species and year.}

\item{crs.src}{Coordinate Reference System of the input data,
specified as a string in the format 'EPSG:<ID>' (for example, 'EPSG:4326').
The function will stop with an error if `crs.src` is not provided in this format.}

\item{parms.out}{Character vector indicating output formats to generate.
Supported values are \code{"csv"}, \code{"tif"},
\code{"png"}, and \code{"gif"}.}

\item{dir.shp}{Character or NULL. Path to the folder containing shapefiles for cropping data to the Canadian boreal regions. Only used for specific research purposes; if NULL (default), no cropping is applied and all data are included.}

\item{dir.out}{Output directory used to save generated files.
Required when \code{parms.out} is not empty.}

\item{animation_fps}{Frames per second used when creating GIF animations.}

\item{...}{Additional arguments passed to
\code{plot_tree_ring_map}, such as \code{png.text}.}
}
\value{
A magick-image object representing an animated GIF composed of the generated frames.
}
\description{
Visualizes spatial interpolation results produced by
\code{\link{CFS_mapping}} and optionally exports raster files,
static maps, and animations.
}
\details{
This function assumes that spatial interpolation has already
been performed using \code{\link{CFS_mapping}}. The input
object is iterated by species and year to generate maps and
optional exports.

When \code{"gif"} is requested in \code{parms.out}, yearly
PNG images are combined into animated GIFs.
}
\examples{
\donttest{
# Load processed demo data
dt.samples_trt <- readRDS(
  system.file("extdata", "dt.samples_trt.rds",
              package = "growthTrendR")
)
# prepare data for IDW model
cols.meta = c("uid_tree", "uid_site", "longitude", "latitude", "species")
dt.mapping <- dt.samples_trt$tr_all_wide[
  , c(..cols.meta, as.character(1991:1995)), with = FALSE]

# Run spatial interpolation
mapping_results <- CFS_mapping(
  dt.mapping,
  year.span = c(1991, 1993)
)

# generate png plots
img_ani <- plot_mapping(
mapping_results = mapping_results,
parms.out = NULL,
dir.shp = NULL,
dir.out = NULL,
png.text = list(
  text_top  = "Ring width measurement - ",
  text_bott = "Source: demo-samples",
  text_side = "ring width (mm)"
)
)
}

}
\seealso{
\code{\link{CFS_mapping}}
}
